#include <bits/stdc++.h>
using namespace std;

#define N 200001
int seg[4 * N];
bool lazy[4 * N];

void switchh(bool &p) {
    if (p)
        p = false;
    else
        p = true;
}

void build(string s, int l, int r, int index) {
    if (l == r) {
        seg[index] = s[l] - '0';
        return;
    }
    int mid = (l + r) / 2;
    build(s, l, mid, index * 2 + 1);
    build(s, mid + 1, r, index * 2 + 2);
    seg[index] = seg[index * 2 + 2] + seg[index * 2 + 1];
}

void update1(int l, int r, int index) {
    switchh(lazy[index]);
    seg[index] = (r - l + 1) - seg[index];
}

void shift(int l, int r, int index) {
    int mid = (l + r) / 2;
    update1(l, mid, index * 2 + 1);
    update1(mid + 1, r, index * 2 + 2);
    switchh(lazy[index]);
}

void update(int l, int r, int x, int y, int index) {
    if (y < l || x > r)
        return;
    if (l >= x && r <= y) {
        update1(l, r, index);
        return;
    }
    if (lazy[index]) {
        shift(l, r, index);
    }
    int mid = (l + r) / 2;
    update(l, mid, x, y, index * 2 + 1);
    update(mid + 1, r, x, y, index * 2 + 2);
    seg[index] = seg[index * 2 + 1] + seg[index * 2 + 2];
}

int sum() {
    return seg[0];
}

void solve() {
    int n, c, q;
    cin >> n >> c >> q;
    string s;
    cin >> s;
    build(s, 0, n - 1, 0);
    while(q--) {
        int l, r;
        cin >> l >> r;
        update(0, n - 1, l - 1, r - 1, 0);
        cout << sum() << endl;
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    solve();
    return 0;
}